/*
 * Decompiled with CFR 0.152.
 */
package de.FBEditor;

import de.FBEditor.ActionListen;
import de.FBEditor.BoxInfo;
import de.FBEditor.CutAndPastePopup;
import de.FBEditor.FindReplace;
import de.FBEditor.FritzBoxConnection;
import de.FBEditor.FritzBoxFirmware;
import de.FBEditor.ImportData;
import de.FBEditor.MyMenu;
import de.FBEditor.struct.CompoundUndoManager;
import de.FBEditor.struct.ExampleFileFilter;
import de.FBEditor.struct.JTextPane2;
import de.FBEditor.struct.MyProperties;
import de.FBEditor.struct.OverwriteCaret;
import de.FBEditor.utils.CalcChecksum;
import de.FBEditor.utils.Debug;
import de.FBEditor.utils.Encryption;
import de.FBEditor.utils.Listener;
import de.FBEditor.utils.Utils;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;

public class FBEdit
extends JFrame
implements Runnable {
    private static final String version = "0.7.2.1";
    private static final String PROPERTIES_FILE = "FBEditor.properties.xml";
    public static FritzBoxConnection fbConnection = null;
    private static Caret overwriteCaret;
    private static Caret insertCaret;
    private static final long serialVersionUID = 1L;
    private static FBEdit INSTANCE;
    private static FritzBoxFirmware firmware;
    private static JTextPane2 pane;
    private String jFile = "";
    private static String box_address;
    private static String box_password;
    private static String box_username;
    private static String readOnStartup;
    private static String NoChecks;
    private static String language;
    private static MyProperties properties;
    private final CompoundUndoManager undoManager;
    private static String progName;
    private String fileName = "";
    private boolean stoprequested = false;
    private static CutAndPastePopup cutAndPaste;
    private ActionListen action;
    private MyMenu myMenu;
    private static boolean insertMode;
    private static DocumentListener docListen;
    private FindReplace findReplace = null;
    private static JPopupMenu popup;
    Thread thread = new Thread(this);
    private static Vector<Locale> supported_languages;
    private static ResourceBundle messages;
    private static ResourceBundle en_messages;

    public FBEdit() {
        String jvm_version = System.getProperty("java.version");
        properties = new MyProperties();
        Utils.createDefaultProperties(properties);
        boolean loadProp = Utils.loadProperties(properties, PROPERTIES_FILE);
        if (loadProp) {
            String position_top = properties.getProperty("position.top", "60");
            String position_left = properties.getProperty("position.left", "60");
            String position_height = properties.getProperty("position.height", "480");
            String position_width = properties.getProperty("position.width", "680");
            System.out.println("position_top: " + position_top);
            System.out.println("position_left: " + position_left);
            System.out.println("position_height: " + position_height);
            System.out.println("position_width: " + position_width);
            this.setLocation(Integer.parseInt(position_left.trim()), Integer.parseInt(position_top.trim()));
            this.setSize(Integer.parseInt(position_width.trim()), Integer.parseInt(position_height.trim()));
        } else {
            this.setLocation(60, 60);
            this.setSize(680, 480);
        }
        this.updateTitle();
        this.setIconImage(this.getImageFromJAR("/icon.gif"));
        pane = new JTextPane2();
        this.setProperties(properties);
        FBEdit.loadLanguages();
        Debug.always("OS Language: " + System.getProperty("user.language"));
        Debug.always("OS Country: " + System.getProperty("user.country"));
        if (language == null || language.equals(false)) {
            Debug.info("No language set yet ... Setting language to OS language");
            if (supported_languages.contains(new Locale(System.getProperty("user.language"), System.getProperty("user.country")))) {
                language = System.getProperty("user.language") + "_" + System.getProperty("user.country");
            } else {
                Debug.warning("Your language ist not yet supported.");
                language = "en_US";
            }
        }
        Debug.always("Selected language: " + language);
        FBEdit.loadMessages(new Locale(language.substring(0, language.indexOf("_")), language.substring(language.indexOf("_") + 1, language.length())));
        this.fileName = FBEdit.getMessage("main.unknown_file");
        Debug.always("Java version: " + jvm_version);
        Font font = null;
        try {
            font = Font.createFont(0, this.getClass().getResourceAsStream("/de/FBEditor/font/Consola.ttf"));
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
            System.out.println("Font: : " + font.getName());
        }
        catch (FontFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!loadProp) {
            this.getHost(true);
            this.getPassword(true);
        }
        this.undoManager = new CompoundUndoManager(pane);
        this.action = new ActionListen(this);
        cutAndPaste = new CutAndPastePopup(this.action);
        popup = cutAndPaste.getPopupMenu();
        this.myMenu = new MyMenu(this);
        JMenuBar menubar = new JMenuBar();
        menubar.add(this.myMenu.createFileMenu());
        menubar.add(this.myMenu.createEditMenu());
        menubar.add(this.myMenu.createConfigMenu());
        menubar.add(this.myMenu.createHelpMenu());
        this.setJMenuBar(menubar);
        this.getContentPane().add((Component)this.myMenu.createStatusBar(), "South");
        this.getContentPane().add((Component)new JScrollPane(pane), "Center");
        pane.setEditable(true);
        pane.setAutoscrolls(true);
        pane.setLineTerm(System.getProperty("line.separator"));
        overwriteCaret = new OverwriteCaret();
        insertCaret = pane.getCaret();
        pane.setCaret(insertMode ? insertCaret : overwriteCaret);
        pane.setCaretPosition(0);
    }

    private void setProperties(MyProperties properties) {
        box_address = properties.getProperty("box.address");
        box_password = Encryption.decrypt(properties.getProperty("box.password"));
        box_username = properties.getProperty("box.username");
        readOnStartup = properties.getProperty("readOnStartup");
        NoChecks = properties.getProperty("NoChecks");
        language = properties.getProperty("language");
    }

    @Override
    public void run() {
        while (!this.stoprequested) {
            this.updateTitle();
            this.myMenu.setstatusMsg(pane);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FBEdit.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void updateMenu(MyMenu myMenu) {
        myMenu.undo.setEnabled(this.undoManager.canUndo());
        myMenu.redo.setEnabled(this.undoManager.canRedo());
        if (pane.getSelectedText() != null) {
            myMenu.copy.setEnabled(true);
            myMenu.cut.setEnabled(true);
            myMenu.delete.setEnabled(true);
        } else {
            myMenu.copy.setEnabled(false);
            myMenu.cut.setEnabled(false);
            myMenu.delete.setEnabled(false);
        }
        Clipboard clipbd = this.getToolkit().getSystemClipboard();
        if (clipbd.getContents(this) != null) {
            myMenu.insert.setEnabled(true);
        } else {
            myMenu.insert.setEnabled(false);
        }
    }

    void undoredo(int addaction) {
        try {
            if (addaction == 1) {
                this.undoManager.undo();
            } else {
                this.undoManager.redo();
            }
            pane.requestFocus();
        }
        catch (CannotRedoException cre) {
            cre.printStackTrace();
        }
        this.updateMenu(this.myMenu);
    }

    public JTextComponent getEditor() {
        return this.undoManager.getEditor();
    }

    void newFile() {
        pane.setText("");
        this.undoManager.discardAllEdits();
    }

    public void exit() {
        this.stoprequested = true;
        Utils.saveProperties(PROPERTIES_FILE, this);
        this.dispose();
        System.exit(0);
    }

    void setCtrlAccelerator(JMenuItem mi, char acc) {
        KeyStroke ks = KeyStroke.getKeyStroke((int)acc, 2);
        mi.setAccelerator(ks);
    }

    void getFile() {
        JTextPane2 pane2 = this.getJTextPane();
        DocumentListener docListen2 = this.getDocListener();
        pane2.setFont(new Font("Consolas", 0, 16));
        this.removeDocumentListener(pane2, docListen2);
        pane2.setText(FBEdit.getMessage("box.get_config"));
        EventQueue.invokeLater(new ImportData());
        this.fileName = "fritzbox.export";
        this.jFile = null;
    }

    public void setData(String data) {
        JTextPane2 pane2 = this.getJTextPane();
        pane2.setText("");
        pane2.setFont(new Font("Consolas", 0, 12));
        pane2.setEditable(false);
        this.undoManager.pause();
        pane2.setText(data);
        pane2.setCaretPosition(0);
        this.undoManager.resume();
        this.undoManager.discardAllEdits();
        FBEdit.addDocumentListener(pane2, this.getDocListener());
        pane2.setEditable(true);
    }

    void putFile() {
        int response = JOptionPane.showConfirmDialog(this, FBEdit.getMessage("box.affirmation"), FBEdit.getMessage("settings.backup"), 0, 0);
        if (response == 0) {
            String text = CalcChecksum.replaceChecksum(this.getJTextPane().getText());
            if (text.startsWith("**** ") && text.endsWith(" ****\n")) {
                if (NoChecks.equals("true")) {
                    int index = text.indexOf("**** CFGFILE:ar7.cfg");
                    text = text.substring(0, index) + "NoChecks=yes" + '\n' + text.substring(index);
                    text = CalcChecksum.replaceChecksum(text);
                }
                boolean result = false;
                result = Utils.exportData(this.getframe(), this.getbox_address(), text);
                if (result) {
                    JOptionPane.showMessageDialog(this, FBEdit.getMessage("box.restart"), FBEdit.getMessage("settings.backup"), 1);
                }
                this.enableMenu(false);
            } else {
                JOptionPane.showMessageDialog(this, FBEdit.getMessage("box.settings_error"), FBEdit.getMessage("settings.backup"), 0);
            }
        }
    }

    void loadFile() {
        JTextPane2 pane2 = this.getJTextPane();
        JFileChooser chooser = new JFileChooser(".");
        ExampleFileFilter filter = new ExampleFileFilter("export");
        filter.setDescription(FBEdit.getMessage("export.file"));
        chooser.setFileFilter(filter);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.fileName = chooser.getSelectedFile().getName();
            this.jFile = chooser.getSelectedFile().getAbsolutePath();
            try {
                FileInputStream fis = new FileInputStream(this.jFile);
                byte[] donnees = new byte[fis.available()];
                fis.read(donnees);
                this.setData(new String(donnees));
                fis.close();
            }
            catch (IOException e) {
                pane2.setText(FBEdit.getMessage("export.load.error"));
            }
            this.undoManager.discardAllEdits();
        }
    }

    void saveFile() {
        JTextPane2 pane2 = this.getJTextPane();
        JFileChooser chooser = new JFileChooser(".");
        ExampleFileFilter filter = new ExampleFileFilter("export");
        filter.setDescription(FBEdit.getMessage("export.file"));
        chooser.setFileFilter(filter);
        chooser.setSelectedFile(new File(this.fileName));
        int returnVal = chooser.showSaveDialog(this);
        if (returnVal == 0) {
            this.fileName = chooser.getSelectedFile().getName();
            this.jFile = chooser.getSelectedFile().getAbsolutePath();
            try {
                FileOutputStream fos = new FileOutputStream(this.jFile);
                PrintStream pfos = new PrintStream(fos);
                String text = CalcChecksum.replaceChecksum(pane2.getText());
                pfos.print(text);
                fos.close();
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this.getframe(), FBEdit.getMessage("export.save.error"), FBEdit.getMessage("main.error"), 0);
            }
            this.undoManager.discardAllEdits();
        }
    }

    void about() {
        JOptionPane.showMessageDialog(this, "Fritz!Box Export Editor " + version + "\n" + "by Oliver Metz\n\n" + FBEdit.getMessage("main.thanks"), FBEdit.getMessage("menu.about"), 0, new ImageIcon(this.getImageFromJAR("/icon.gif")));
    }

    void showBoxInfo() {
        BoxInfo hardware = new BoxInfo(firmware.getBoxName(), firmware.getFirmwareVersion(), firmware.getModFirmwareVersion());
    }

    void getHost(boolean first) {
        String new_box_address = JOptionPane.showInputDialog(this, FBEdit.getMessage("settings.host_ip"), box_address);
        if (new_box_address != null && !new_box_address.equals(box_address)) {
            box_address = new_box_address;
        }
        if (!first) {
            FBEdit.makeNewConnection(first);
        }
    }

    void getPassword(boolean first) {
        JPasswordField field = new JPasswordField(box_password);
        JOptionPane.showConfirmDialog(this, field, FBEdit.getMessage("settings.password"), 2, 1);
        field.requestFocus();
        String newPass = new String(field.getPassword());
        if (newPass != null && !newPass.equals(box_password)) {
            box_password = newPass;
            if (!first) {
                FBEdit.makeNewConnection(first);
            }
        }
    }

    void getUsername(boolean first) {
        String new_box_username = JOptionPane.showInputDialog(this, FBEdit.getMessage("settings.username"), box_username);
        if (new_box_username != null && !new_box_username.equals(box_username)) {
            box_username = new_box_username;
        }
        if (!first) {
            FBEdit.makeNewConnection(first);
        }
    }

    public void enableMenu(boolean bool) {
        this.myMenu.hardmenu.setEnabled(bool);
        this.myMenu.importcfg.setEnabled(bool);
        this.myMenu.exportcfg.setEnabled(bool);
        this.myMenu.reconnect.setEnabled(true);
    }

    public void disableMenu() {
        this.myMenu.hardmenu.setEnabled(false);
        this.myMenu.importcfg.setEnabled(false);
        this.myMenu.exportcfg.setEnabled(false);
        this.myMenu.reconnect.setEnabled(false);
    }

    public static FBEdit getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FBEdit();
        }
        return INSTANCE;
    }

    private static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] s) {
        FBEdit fbedit = new FBEdit();
        docListen = Listener.myDocumentListener(fbedit);
        FBEdit.addDocumentListener(pane, docListen);
        Listener.addWinListener(fbedit);
        Listener.addKeyListener(fbedit);
        Listener.addMouseListener(fbedit, cutAndPaste, popup);
        fbedit.setVisible(true);
        INSTANCE = fbedit;
        fbedit.thread.start();
        FBEdit.sleep(2000L);
        FBEdit.makeNewConnection(true);
    }

    public static void makeNewConnection(Boolean firstStart) {
        FBEdit.getInstance().disableMenu();
        fbConnection = new FritzBoxConnection(box_address, box_password, box_username);
        if (fbConnection.isConnected()) {
            firmware = fbConnection.getFirmware();
            if (firmware.getMajorFirmwareVersion() == 4 || firmware.getMajorFirmwareVersion() >= 5) {
                FBEdit.getInstance().enableMenu(true);
            } else {
                FBEdit.getInstance().enableMenu(false);
            }
            if (firstStart.booleanValue() && Boolean.parseBoolean(readOnStartup)) {
                FBEdit.getInstance().getFile();
            }
        } else {
            JOptionPane.showMessageDialog(INSTANCE, FBEdit.getMessage("box.not_found"), FBEdit.getMessage("main.error"), 0);
        }
    }

    public String getbox_address() {
        return box_address;
    }

    public String getbox_password() {
        return box_password;
    }

    public String getbox_username() {
        return box_username;
    }

    public MyMenu getMenu() {
        return this.myMenu;
    }

    public FBEdit getframe() {
        return this;
    }

    void updateTitle() {
        this.setTitle(String.valueOf(progName) + " - " + this.fileName);
    }

    void search() {
        this.findReplace = new FindReplace(this, 1);
    }

    void replace() {
        this.findReplace = new FindReplace(this, 2);
    }

    public JTextPane2 getJTextPane() {
        return pane;
    }

    CompoundUndoManager getUndoManager() {
        return this.undoManager;
    }

    private static void addDocumentListener(JTextPane2 pane2, DocumentListener doclisten) {
        pane2.getDocument().addDocumentListener(doclisten);
    }

    private void removeDocumentListener(JTextPane2 pane2, DocumentListener docListen) {
        pane2.getDocument().removeDocumentListener(docListen);
    }

    public static boolean isInsertMode() {
        return insertMode;
    }

    public void toggleInsertMode() {
        insertMode = !insertMode;
    }

    public static void setInsertMode(boolean insertM) {
        insertMode = insertM;
    }

    public void selectCaret(JTextPane2 pane2) {
        Caret newCaret;
        Caret caret = newCaret = insertMode ? insertCaret : overwriteCaret;
        if (newCaret != pane2.getCaret()) {
            Caret caret2 = pane2.getCaret();
            int mark = caret2.getMark();
            int dot = caret2.getDot();
            caret2.setVisible(false);
            pane2.setCaret(newCaret);
            newCaret.setDot(mark);
            newCaret.moveDot(dot);
            newCaret.setVisible(true);
        }
    }

    public void setCaret(Caret caret) {
        insertCaret = caret;
    }

    public void setOverwriteCaret(Caret caret) {
        overwriteCaret = caret;
    }

    public Caret getOverwriteCaret() {
        return overwriteCaret;
    }

    public Image getImageFromJAR(String fileName) {
        return Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(fileName));
    }

    public String getRASstate() {
        return readOnStartup;
    }

    public void changeRAS() {
        readOnStartup = readOnStartup.equalsIgnoreCase("true") ? "false" : "true";
        this.myMenu.readOnStartup.setState(Boolean.parseBoolean(readOnStartup));
    }

    public String getNoChecksState() {
        return NoChecks;
    }

    public String getLanguage() {
        return language;
    }

    public void changeNoChecks() {
        NoChecks = NoChecks.equalsIgnoreCase("true") ? "false" : "true";
        this.myMenu.NoChecks.setState(Boolean.parseBoolean(NoChecks));
    }

    public FindReplace getFindReplace() {
        return this.findReplace;
    }

    private DocumentListener getDocListener() {
        return docListen;
    }

    public ActionListen getActionListener() {
        return this.action;
    }

    public CutAndPastePopup getCutAndPaste() {
        return cutAndPaste;
    }

    private static void loadLanguages() {
        supported_languages = new Vector();
        supported_languages.add(new Locale("de", "DE"));
        supported_languages.add(new Locale("en", "US"));
        supported_languages.add(new Locale("es", "ES"));
    }

    public static void loadMessages(Locale locale) {
        try {
            Debug.info("Loading locale: " + locale);
            en_messages = ResourceBundle.getBundle("fbeditor", new Locale("en", "US"));
            messages = ResourceBundle.getBundle("fbeditor", locale);
        }
        catch (MissingResourceException e) {
            Debug.error("Can't find i18n resource! (\"fbeditor_" + locale + ".properties\")");
            JOptionPane.showMessageDialog(null, progName + " v" + version + "\n\nCannot find the language file \"fbeditor_" + locale + ".properties\"!" + "\nProgram will exit!");
        }
    }

    public static String getMessage(String msg) {
        String i18n = "";
        try {
            i18n = !messages.getString(msg).equals("") ? messages.getString(msg) : msg;
        }
        catch (MissingResourceException e) {
            Debug.error("Can't find resource string for " + msg);
            i18n = en_messages.getString(msg);
        }
        return i18n;
    }

    static {
        INSTANCE = null;
        firmware = null;
        box_address = "";
        box_password = "";
        box_username = "";
        readOnStartup = "false";
        NoChecks = "false";
        language = "false";
        progName = "Fritz!Box Export Editor";
        insertMode = true;
    }
}

