/*
 * Decompiled with CFR 0.152.
 */
package de.FBEditor;

import de.FBEditor.FBEdit;
import de.FBEditor.FritzBoxFirmware;
import de.FBEditor.struct.FBFWVN;
import de.FBEditor.struct.HttpPost;
import de.FBEditor.struct.SIDLogin;
import de.FBEditor.utils.Utils;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class FritzBoxConnection {
    private boolean connected = false;
    private static FritzBoxFirmware firmware;
    private SIDLogin sidLogin;
    private String postdata;
    private String urlstr;
    private String urlstr1;
    private String box_password;
    private String box_username;
    private static String sRetSID;

    public FritzBoxConnection(String box_address, String box_password, String box_username) {
        this.updateURLstr(box_address);
        try {
            this.box_password = box_password;
            this.box_username = box_username;
            this.sidLogin = new SIDLogin();
            if (Utils.checkhost(box_address)) {
                this.getAccessMethod();
            }
        }
        catch (IOException ex) {
            Logger.getLogger(FritzBoxConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void updateURLstr(String boxAddress) {
        this.urlstr1 = this.urlstr = "http://" + boxAddress + "/cgi-bin/webcm";
    }

    void getAccessMethod() {
        String data = "";
        String language = "de";
        Boolean speedport = false;
        boolean detected = false;
        SIDLogin.check("", this.urlstr1, this.box_password, this.box_username, sRetSID);
        sRetSID = SIDLogin.getSessionId();
        FBFWVN fbfwvn = new FBFWVN(this.getFirmwareStatus());
        if (SIDLogin.isSidLogin()) {
            if (fbfwvn.isOK()) {
                detected = true;
            }
        } else if (SIDLogin.isLogin()) {
            detected = true;
        }
        if (detected) {
            this.connected = true;
        }
        if (!detected) {
            JOptionPane.showMessageDialog(FBEdit.getInstance().getframe(), FBEdit.getMessage("utils.read_error"), FBEdit.getMessage("main.error"), 0);
            return;
        }
        String FritzboxName = "";
        String boxtypeString = "";
        String majorFirmwareVersion = "";
        String minorFirmwareVersion = "";
        String modFirmwareVersion = "";
        if (fbfwvn.isOK()) {
            FritzboxName = fbfwvn.getFritzbox();
            boxtypeString = fbfwvn.getBoxTypeFBFWVN();
            majorFirmwareVersion = fbfwvn.getMajorFBFWVN();
            minorFirmwareVersion = fbfwvn.getMinorFBFWVN();
            modFirmwareVersion = fbfwvn.getModFBFWVN();
            if (fbfwvn.isFritzboxLanguage()) {
                language = fbfwvn.getFritzboxLanguage().toLowerCase();
            }
        } else {
            HttpPost http = new HttpPost();
            boolean isQueryOld = false;
            String url = this.urlstr;
            String sRetQueryOld = "";
            String sRetQueryNew = "";
            this.postdata = "sid=" + sRetSID + "&" + "getpage=../html/query.txt&var:cnt=1" + "&var:n" + "0" + "=" + "logic:status/nspver";
            sRetQueryOld = http.Post2(url, this.postdata);
            this.postdata = "sid=" + sRetSID + "&" + "getpage=../html/query.txt&var:cnt=1" + "&var:n[" + "0" + "]=" + "logic:status/nspver";
            sRetQueryNew = http.Post2(url, this.postdata);
            if (sRetQueryOld.length() > sRetQueryNew.length()) {
                isQueryOld = true;
                data = sRetQueryOld;
            } else {
                data = sRetQueryNew;
            }
            System.out.println(url);
            System.out.println("QueryOld: " + isQueryOld + "     " + sRetQueryOld + "     " + sRetQueryNew);
            Pattern normalFirmware = Pattern.compile("([0-9]*).([0-9]*).([0-9]*)[|-]?([^[0-9]<]*)");
            Matcher m = normalFirmware.matcher(data);
            if (m.find()) {
                boxtypeString = m.group(1);
                majorFirmwareVersion = m.group(2);
                minorFirmwareVersion = m.group(3);
                modFirmwareVersion = "";
                try {
                    modFirmwareVersion = m.group(4);
                    System.out.println("modFirmwareVersion: " + m.group(4));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("error modFirmwareVersion: " + m.group(4));
                }
            }
        }
        firmware = new FritzBoxFirmware(FritzboxName, boxtypeString, majorFirmwareVersion, minorFirmwareVersion, modFirmwareVersion, language);
        System.out.println("Debug boxtype: " + boxtypeString);
    }

    public boolean reconnect(String box_address, String box_password, String box_username) {
        boolean result = false;
        this.connected = false;
        try {
            this.updateURLstr(box_address);
            this.box_password = box_password;
            this.box_username = box_username;
            if (Utils.checkhost(box_address)) {
                sRetSID = SIDLogin.getSessionId();
                SIDLogin.check("", this.urlstr1, box_password, box_username, sRetSID);
                sRetSID = SIDLogin.getSessionId();
                if (SIDLogin.isSidLogin()) {
                    result = true;
                    this.connected = true;
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(FritzBoxConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public FritzBoxFirmware getFirmware() {
        return firmware;
    }

    public String getFirmwareStatus() {
        HttpPost http = new HttpPost();
        String url = "http://" + FBEdit.getInstance().getbox_address() + "/cgi-bin/system_status";
        String sFBFW_Status = http.Post(url, "");
        return sFBFW_Status;
    }

    static {
        sRetSID = "0000000000000000";
    }
}

