/*
 * Decompiled with CFR 0.152.
 */
package de.FBEditor.utils;

import de.FBEditor.utils.LogSeverity;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class Debug {
    public static final LogSeverity LS_ALWAYS = new LogSeverity(0, "LS_ALWAYS", "");
    public static final LogSeverity LS_ERROR = new LogSeverity(1, "LS_ERROR", ": ERROR");
    public static final LogSeverity LS_WARNING = new LogSeverity(2, "LS_WARNING", ": WARNING");
    public static final LogSeverity LS_NETWORK = new LogSeverity(3, "LS_NETWORK", ": NETWORK");
    public static final LogSeverity LS_INFO = new LogSeverity(4, "LS_INFO", ": INFO");
    public static final LogSeverity LS_DEBUG = new LogSeverity(5, "LS_DEBUG", ": DEBUG");
    private static final long serialVersionUID = 9211082107025215527L;
    private static LogSeverity debugLevel;
    private static String debugLogFile;
    private static boolean verboseMode;
    private static PrintStream fileRedirecter;
    private static PrintStream originalOut;
    private static JPanel main_panel;
    private static JTextArea log_area;
    private static JButton close_button;
    private static JButton save_button;
    private static JButton refresh_button;
    private static JComboBox log_severity_box;

    public static void on() {
        verboseMode = false;
        debugLevel = LS_DEBUG;
    }

    public static void logToFile(String fName) {
        debugLogFile = fName;
        originalOut = System.out;
        try {
            FileOutputStream tmpOutputStream = new FileOutputStream(debugLogFile);
            fileRedirecter = new PrintStream(tmpOutputStream);
            System.setOut(fileRedirecter);
            System.setErr(fileRedirecter);
        }
        catch (Exception e) {
            System.err.println("EXCEPTION when writing to LOGFILE");
        }
    }

    private static String getCurrentTime() {
        Date now = new Date();
        SimpleDateFormat df = new SimpleDateFormat("dd.MM.yy HH:mm:ss");
        return df.format(now);
    }

    private static void msg(LogSeverity level, String msg) {
        if (debugLevel == null || debugLevel != null && debugLevel.getId() >= level.getId()) {
            String message = msg;
            message = "(" + Debug.getCurrentTime() + ")" + level.getPrefix() + ": " + message;
            System.out.println(message);
            if (verboseMode) {
                originalOut.println(message);
            }
        }
    }

    public static void netMsg(String msg) {
        Debug.msg(LS_NETWORK, msg);
    }

    public static void always(String msg) {
        Debug.msg(LS_ALWAYS, msg);
    }

    public static void error(String msg) {
        Debug.msg(LS_ERROR, msg);
    }

    public static void warning(String msg) {
        Debug.msg(LS_WARNING, msg);
    }

    public static void info(String msg) {
        Debug.msg(LS_INFO, msg);
    }

    public static void debug(String msg) {
        Debug.msg(LS_DEBUG, msg);
    }

    private static void loadDebugFile() {
        try {
            int selectedLogSeverityIndex = log_severity_box.getSelectedIndex();
            LogSeverity selectedLogSeverity = (LogSeverity)log_severity_box.getItemAt(selectedLogSeverityIndex);
            log_area.setText("");
            BufferedReader in = new BufferedReader(new FileReader(debugLogFile));
            String zeile = null;
            while ((zeile = in.readLine()) != null) {
                if (selectedLogSeverity.getId() < Debug.returnLineSeverity(zeile).getId()) continue;
                log_area.append(zeile + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static LogSeverity returnLineSeverity(String line) {
        LogSeverity ls = LS_DEBUG;
        ls = line.substring(19).startsWith(LS_DEBUG.getPrefix()) ? LS_DEBUG : (line.substring(19).startsWith(LS_INFO.getPrefix()) ? LS_INFO : (line.substring(19).startsWith(LS_NETWORK.getPrefix()) ? LS_NETWORK : (line.substring(19).startsWith(LS_WARNING.getPrefix()) ? LS_WARNING : (line.substring(19).startsWith(LS_ERROR.getPrefix()) ? LS_ERROR : LS_ALWAYS))));
        return ls;
    }

    public static JPanel getPanel() {
        Debug.loadDebugFile();
        return main_panel;
    }

    public static void setCloseButtonText(String text) {
        close_button.setText(text);
    }

    public static void setSaveButtonText(String text) {
        save_button.setText(text);
    }

    public static void setRefreshButtonText(String text) {
        refresh_button.setText(text);
    }

    public static void setVerbose(boolean verbose) {
        verboseMode = verbose;
    }

    public static void setDebugLevel(LogSeverity level) {
        debugLevel = level;
        Debug.info("Set debug level to " + level.getName());
    }

    static {
        verboseMode = false;
        main_panel = null;
    }
}

