/*
 * Decompiled with CFR 0.152.
 */
package de.FBEditor.utils;

import de.FBEditor.FBEdit;
import de.FBEditor.FritzBoxFirmware;
import de.FBEditor.struct.MyProperties;
import de.FBEditor.struct.SIDLogin;
import de.FBEditor.utils.Encryption;
import de.FBEditor.utils.HTMLUtil;
import de.FBEditor.utils.StringPartNoTransferEncoding;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;

public class Utils {
    public static boolean checkhost(String host) throws IOException {
        Boolean bool = false;
        Pattern p = Pattern.compile(":");
        String[] temp = p.split(host);
        InetAddress addr = InetAddress.getByName(temp[0]);
        int port = temp.length == 2 ? Integer.valueOf(temp[1]) : 80;
        InetSocketAddress sockaddr = new InetSocketAddress(addr, port);
        Socket test = new Socket();
        int timeoutMs = 1000;
        test.connect(sockaddr, timeoutMs);
        test.close();
        bool = true;
        return bool;
    }

    public static String pMatch(String s, String s1, int i) {
        Pattern pattern = Pattern.compile(s, 2);
        Matcher matcher = pattern.matcher(s1);
        if (matcher.find()) {
            return matcher.group(i);
        }
        return null;
    }

    public static boolean exportData(FBEdit fbedit, String box_address, String data) {
        boolean result = false;
        FritzBoxFirmware firmware = null;
        firmware = FBEdit.fbConnection.getFirmware();
        try {
            int len;
            String url = "http://" + box_address + "/cgi-bin/firmwarecfg";
            File uploadFile = Utils.createTempFile(data);
            PostMethod mPost = new PostMethod(url);
            String sid = SIDLogin.getSessionId();
            Part[] parts = null;
            if (SIDLogin.isSidLogin()) {
                if (firmware.getMajorFirmwareVersion() >= 6) {
                    System.out.println("DEBUG: firmware.getMajorFirmwareVersion() >= 6: " + firmware.getMajorFirmwareVersion());
                    parts = new Part[]{new StringPartNoTransferEncoding("sid", sid), new StringPartNoTransferEncoding("ImportExportPassword", ""), new FilePart("ConfigImportFile", uploadFile.getName(), uploadFile), new StringPartNoTransferEncoding("apply", "")};
                } else {
                    System.out.println("DEBUG: firmware.getMajorFirmwareVersion(): " + firmware.getMajorFirmwareVersion());
                    parts = new Part[]{new StringPartNoTransferEncoding("sid", sid), new StringPartNoTransferEncoding("ImportExportPassword", ""), new FilePart("ConfigImportFile", uploadFile.getName(), uploadFile)};
                }
            } else {
                parts = new Part[]{new StringPartNoTransferEncoding("ImportExportPassword", ""), new FilePart("ConfigImportFile", uploadFile.getName(), uploadFile)};
            }
            mPost.setRequestEntity(new MultipartRequestEntity(parts, mPost.getParams()));
            HttpClient client = new HttpClient();
            client.getHttpConnectionManager().getParams().setConnectionTimeout(8000);
            int statusCode1 = client.executeMethod(mPost);
            BufferedInputStream bis = new BufferedInputStream(mPost.getResponseBodyAsStream());
            byte[] buf = new byte[4096];
            StringBuffer sb = new StringBuffer();
            while ((len = bis.read(buf)) > 0) {
                sb.append(new String(buf, 0, len));
            }
            data = HTMLUtil.stripEntities(sb.toString());
            data = HTMLUtil.stripNbsp(data);
            bis.close();
            if (statusCode1 == 200 && Utils.checkResponse(data)) {
                result = true;
            } else {
                JOptionPane.showMessageDialog(fbedit, FBEdit.getMessage(""), FBEdit.getMessage("error"), 0);
            }
            mPost.releaseConnection();
        }
        catch (IOException ex) {
            Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    public static boolean createDefaultProperties(MyProperties properties) {
        System.out.println("Properties Set using default values");
        properties.setProperty("position.top", "60");
        properties.setProperty("position.left", "60");
        properties.setProperty("position.height", "480");
        properties.setProperty("position.width", "680");
        properties.setProperty("box.address", "fritz.box");
        properties.setProperty("box.password", "");
        properties.setProperty("box.username", "");
        properties.setProperty("readOnStartup", "no");
        properties.setProperty("NoChecks", "false");
        properties.setProperty("language", "de_DE");
        return true;
    }

    public static boolean loadProperties(MyProperties properties, String PROPERTIES_FILE) {
        try {
            FileInputStream fis = new FileInputStream(PROPERTIES_FILE);
            properties.loadFromXML(fis);
            fis.close();
            return true;
        }
        catch (FileNotFoundException e) {
            System.out.println("File " + PROPERTIES_FILE + " not found, using default values");
            properties.setProperty("box.address", "fritz.box");
            properties.setProperty("box.password", "");
            properties.setProperty("box.username", "");
            properties.setProperty("readOnStartup", "no");
            properties.setProperty("NoChecks", "false");
            properties.setProperty("language", "de_DE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void saveProperties(String PROPERTIES_FILE, FBEdit fbedit) {
        MyProperties properties = new MyProperties();
        properties.setProperty("position.left", Integer.toString(fbedit.getLocation().x));
        properties.setProperty("position.top", Integer.toString(fbedit.getLocation().y));
        properties.setProperty("position.width", Integer.toString(fbedit.getSize().width));
        properties.setProperty("position.height", Integer.toString(fbedit.getSize().height));
        properties.setProperty("box.password", Encryption.encrypt(fbedit.getbox_password()));
        properties.setProperty("box.username", fbedit.getbox_username());
        properties.setProperty("box.address", fbedit.getbox_address());
        properties.setProperty("readOnStartup", fbedit.getRASstate());
        properties.setProperty("NoChecks", fbedit.getNoChecksState());
        properties.setProperty("language", fbedit.getLanguage());
        try {
            FileOutputStream fos = new FileOutputStream(PROPERTIES_FILE);
            properties.storeToXML(fos, "Properties for FBEditor");
            fos.close();
        }
        catch (FileNotFoundException filenotfoundexception) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File createTempFile(String data) throws IOException {
        File temp = File.createTempFile("FRITZ.BOX", ".export");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(data);
        out.close();
        return temp;
    }

    private static boolean checkResponse(String data) {
        return data.indexOf("fehlgeschlagen") == -1;
    }
}

